#include "openGLControl.h"

COpenGLControl::COpenGLControl()
{
	initScene = NULL;
	renderScene = NULL;
	releaseScene = NULL;
}

bool COpenGLControl::initOpenGL(HWND a_hWnd, void (*a_initScene)(), void (*a_renderScene)(), void(*a_releaseScene)())
{
	hDC = GetDC(a_hWnd);

	if(hDC == NULL)
	{
		return false;
	}

	PIXELFORMATDESCRIPTOR pfd;

	memset(&pfd, 0, sizeof(PIXELFORMATDESCRIPTOR));

	pfd.nSize = sizeof(PIXELFORMATDESCRIPTOR);
	pfd.nVersion = 1;
	pfd.dwFlags = PFD_DOUBLEBUFFER | PFD_SUPPORT_OPENGL | PFD_DRAW_TO_WINDOW;
	pfd.iPixelType = PFD_TYPE_RGBA;
	pfd.cColorBits = 32;
	pfd.cDepthBits = 24;
	pfd.iLayerType = PFD_MAIN_PLANE;

	int PixelFormat = ChoosePixelFormat(hDC, &pfd);

	if(PixelFormat == 0)
	{
		return false;
	}

	if(SetPixelFormat(hDC, PixelFormat, &pfd) == FALSE)
	{
		return false;
	}

	hRC = wglCreateContext(hDC);

	if(hRC == NULL)
	{
		return false;
	}
	
	if(wglMakeCurrent(hDC, hRC) == FALSE)
	{
		return false;
	}

	if(glewInit() != GLEW_OK)
	{
		return false;
	}

	if(WGLEW_ARB_create_context)
	{
		wglDeleteContext(hRC);

		int GL33RCAttribs[] =
		{
			WGL_CONTEXT_MAJOR_VERSION_ARB, 3,
			WGL_CONTEXT_MINOR_VERSION_ARB, 3,
			WGL_CONTEXT_FLAGS_ARB, WGL_CONTEXT_FORWARD_COMPATIBLE_BIT_ARB,
			0
		};

		hRC = wglCreateContextAttribsARB(hDC, 0, GL33RCAttribs);

		if(hRC == NULL)
		{
			return false;
		}

		if(wglMakeCurrent(hDC, hRC) == FALSE)
		{
			return false;
		}

	}
	else
	{
		return false;
	}

	renderScene = a_renderScene;
	initScene = a_initScene;
	releaseScene = a_releaseScene;

	if(initScene != NULL)
	{
		initScene();
	}

	return true;
}

void COpenGLControl::render()
{
	if(renderScene)
	{
		renderScene();
	}

	SwapBuffers(hDC);
}

void COpenGLControl::releaseOpenGLControl()
{
	if(releaseScene && GLEW_VERSION_3_3)
	{
		releaseScene();
	}

	wglDeleteContext(hRC);
}
